/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.config.DynamicSelection;
import jace.core.Card;
import jace.core.Device;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SoundMixer
extends Device {
    private Set<SourceDataLine> availableLines = Collections.synchronizedSet(new HashSet());
    private Map<Object, SourceDataLine> activeLines = Collections.synchronizedMap(new HashMap());
    @ConfigurableField(name="Bits per sample", shortName="bits")
    public static int BITS = 16;
    @ConfigurableField(name="Playback Rate", shortName="freq")
    public static int RATE = 48000;
    private AudioFormat af;
    public boolean lineAvailable;
    @ConfigurableField(name="Audio device", description="Audio output device")
    public static DynamicSelection<String> preferredMixer = new DynamicSelection<String>(null){

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public LinkedHashMap<? extends String, String> getSelections() {
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
            for (Mixer.Info i : mixerInfo) {
                out.put(i.getName(), i.getName());
            }
            return out;
        }
    };
    private Mixer theMixer;

    @Override
    public String getDeviceName() {
        return "Sound Output";
    }

    @Override
    public String getShortName() {
        return "mixer";
    }

    @Override
    public synchronized void reconfigure() {
        this.detach();
        try {
            this.initMixer();
            if (this.lineAvailable) {
                this.initAudio();
                System.out.println("Started sound");
            } else {
                System.out.println("Sound not stared: Line not available");
            }
        }
        catch (LineUnavailableException ex) {
            System.out.println("Unable to start sound");
            Logger.getLogger(SoundMixer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.attach();
    }

    private void initAudio() throws LineUnavailableException {
        this.af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, RATE, BITS, 2, BITS / 4, RATE, true);
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, this.af);
        this.lineAvailable = AudioSystem.isLineSupported(dli);
    }

    public synchronized SourceDataLine getLine(Object requester) throws LineUnavailableException {
        if (this.activeLines.containsKey(requester)) {
            return this.activeLines.get(requester);
        }
        SourceDataLine sdl = null;
        if (this.availableLines.isEmpty()) {
            sdl = this.getNewLine();
        } else {
            sdl = this.availableLines.iterator().next();
            this.availableLines.remove(sdl);
        }
        this.activeLines.put(requester, sdl);
        sdl.start();
        return sdl;
    }

    public void returnLine(Object requester) {
        if (this.activeLines.containsKey(requester)) {
            SourceDataLine sdl = this.activeLines.remove(requester);
            sdl.stop();
            sdl.flush();
            this.availableLines.add(sdl);
        }
    }

    private SourceDataLine getNewLine() throws LineUnavailableException {
        SourceDataLine l = null;
        Line.Info[] info = this.theMixer.getSourceLineInfo();
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, this.af);
        System.out.println("Maximum output lines: " + this.theMixer.getMaxLines(dli));
        System.out.println("Allocated output lines: " + this.theMixer.getSourceLines().length);
        System.out.println("Getting source line from " + this.theMixer.getMixerInfo().toString() + ": " + this.af.toString());
        try {
            l = (SourceDataLine)this.theMixer.getLine(dli);
        }
        catch (IllegalArgumentException e) {
            this.lineAvailable = false;
            throw new LineUnavailableException(e.getMessage());
        }
        catch (LineUnavailableException e) {
            this.lineAvailable = false;
            throw e;
        }
        if (!(l instanceof SourceDataLine)) {
            this.lineAvailable = false;
            throw new LineUnavailableException("Line is not an output line!");
        }
        SourceDataLine sdl = l;
        sdl.open();
        sdl.start();
        return sdl;
    }

    public byte randomByte() {
        return (byte)(Math.random() * 256.0);
    }

    @Override
    public void tick() {
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
        for (SourceDataLine line : this.availableLines) {
            line.close();
        }
        HashSet<Object> requesters = new HashSet<Object>(this.activeLines.keySet());
        for (Object e : requesters) {
            if (e instanceof Device) {
                ((Device)e).detach();
            }
            if (!(e instanceof Card)) continue;
            ((Card)e).reconfigure();
        }
        if (this.theMixer != null) {
            for (Line l : this.theMixer.getSourceLines()) {
                l.close();
            }
        }
        this.availableLines.clear();
        this.activeLines.clear();
    }

    private void initMixer() {
        Mixer.Info selected = null;
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        if (mixerInfo == null || mixerInfo.length == 0) {
            this.theMixer = null;
            this.lineAvailable = false;
            System.out.println("No sound mixer is available!");
            return;
        }
        String mixer = preferredMixer.getValue();
        selected = mixerInfo[0];
        for (Mixer.Info i : mixerInfo) {
            if (!i.getName().equalsIgnoreCase(mixer)) continue;
            selected = i;
            break;
        }
        this.theMixer = AudioSystem.getMixer(selected);
        for (Line l : this.theMixer.getSourceLines()) {
            l.close();
        }
        this.lineAvailable = true;
    }
}

